<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Services\GoogleAdsService;
use App\Traits\AdsSpentTrait;
use App\Traits\GoogleTrait;
use Illuminate\Http\Request;

class GoogleAdsController extends Controller
{
    use GoogleTrait, AdsSpentTrait;

    function google_ads(Request $request)
    {
        $client = User::find($request->client_id);
        $customerId = $client->customer_id;
        $googleAdsService = new GoogleAdsService();
        $data = $googleAdsService->getAds($customerId);

        return $data;
    }

    function google_ads_conversion_action(Request $request)
    {
        $client = User::find($request->client_id);
        $customerId = $client->customer_id;
        $googleAdsService = new GoogleAdsService();
        $data = $googleAdsService->getConversionActions($customerId);

        return $data;
    }
}
