@section('title', 'Forgot Password')
@php
    $title = 'Forgot Password';
@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/iofrm-style.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/iofrm-theme12.css">
</head>

<body>
    <div class="form-body">
        <div class="row">
            <div class="form-holder">
                <div class="form-content">
                    <div class="form-items">
                        <div class="website-logo-inside">
                            <a href="#">
                                <div class="">
                                    <img class="logo-size" src="{{ asset('front') }}/assets/images/OSHTA-Logo.png"
                                        alt="">
                                </div>
                            </a>
                        </div>
                        <h3 class="card-title text-white">User Forgot Password?</h3>
                        <p class="card-text mb-5">Enter your registered email Address to reset the password</p>
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif

                        @if (session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif
                        <form class="form-body" action="{{ route('auth.send_email') }}" method="post">
                            @csrf
                            <div class="row g-3">
                                <div class="col-12">
                                    <label for="inputEmailid" class="form-label">Email</label>
                                    <input type="email" class="form-control form-control-lg radius-30" name="email"
                                        value="{{ old('email') }}" id="inputEmailid" placeholder="Email Address"
                                        required>
                                    @error('email')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <div class="d-grid gap-3">
                                        <button type="submit" class="btn btn-lg btn-primary radius-30">Send</button>
                                        <a href="{{ route('auth.login') }}" class="btn btn-lg btn-light radius-30">Back
                                            to Login</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="login-image-div-monkey">
        <img src="{{ asset('front') }}/assets/css/images/login_mbl_image2.png" class="monkey_image" alt="">
    </div>

    <div class="login-image-div">
        <img src="{{ asset('front') }}/assets/css/images/login_mbl_image1.png" class="footer_image" alt="">
    </div>
    <script src="{{ asset('front') }}/assets/js/jquery.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/popper.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/bootstrap.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/main.js"></script>
</body>

</html>

@section('page-script')

@endsection
