@extends('layouts.front')
@section('page-css')
<!-- JQuery DataTable Css -->
<link rel="stylesheet" href="{{asset('front')}}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-lg-5 col-md-5 col-sm-12">
                    <h2>{{$title}}</h2>
                    <ul class="breadcrumb padding-0">
                        <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">{{ $title }}</li>
                    </ul>
                </div>
            </div>
        </div>


        <div class="row clearfix">
            <div class="col-lg-12">
                  <div class="card">
                    <div class="body">
                        <h2 class="card-inside-title">{{$sub_title}}</h2>
                        <form action="{{route('user.userprofile.update')}}" method="post" class="ajaxForm" 
                        enctype="multipart/form-data">
                            @csrf
                            <div class="row clearfix">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Full Name</label>
                                        <input type="text" class="form-control" placeholder="Full Name"
                                            name="full_name"  value="{{ $edit->full_name ?? '' }}"/>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Date Of Birth</label>
                                        <input type="date" class="form-control" placeholder="" name="date_of_birth" 
                                        value="{{ $edit->date_of_birth ?? '' }}"/>
                                    </div>
                                </div>
                            </div>

                            <div class="row clearfix">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Profession</label>
                                        <input type="text" class="form-control" placeholder="profession"
                                            name="profession" value="{{ $edit->profession ?? '' }}"/>
                                    </div>
                                </div>


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Experience</label>
                                        <input type="text" class="form-control" placeholder="" name="experience" 
                                        value="{{ $edit->experience ?? '' }}"/>
                                    </div>
                                </div>
                            </div>


                            <div class="row clearfix">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Country</label>
                                        <input type="text" class="form-control" placeholder="country" name="country" 
                                        value="{{ $edit->country ?? '' }}"/>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Profile Image</label>
                                            <input type="file" class="form-control radius-30 ps-5" name="profile_image"
                                                value="" style="height: 40px;">
                                        <small class="text-danger">Image must be at least  png ,jpeg ,jpg.</small>
                                    </div>
                                </div>
                            </div>
                            <div class="row clearfix">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Email Address</label>
                                        <input type="email" class="form-control" placeholder="" name="email" 
                                        value="{{ $edit->email ?? '' }}" readonly/>
                                    </div>
                                </div>
                            </div>
                            <input type="hidden" name="id" value="{{$edit->id}}">

                            @if(!isset($edit->id))
                            <br>

                            <div class="row mb-4">

                                <div class="form-check">
                                    <input type="checkbox" name="check_next" id="stayOnPage" value="1">

                                    <label class="form-check-label" for="stayOnPage">
                                        Stay On this page after i clicked <strong>Save</strong>
                                    </label>
                                </div>


                            </div>

                            @endif
                            <input type="hidden" name="id" value="{{$edit->hashid}}">
                            <button type="submit"
                                class="btn btn-raised btn-primary btn-round waves-effect">{{isset($edit) ? 'Update' :
                                'Save'}}</button>
                        </form>
                    </div>

                </div>


                 {{-- for password --}}
                 <div class="card">
                    <div class="body">

                        <h2 class="card-inside-title">Update Password</h2>
                        <form action="{{route('user.profile.update_password')}}" method="post" class="ajaxForm">
                            @csrf

                            <div class="row clearfix">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="">Current Password</label>
                                        <input type="text" class="form-control" placeholder="Enter current password"
                                            name="current_password" required />
                                    </div>
                                </div>
                            </div>
                            <div class="row clearfix">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">New Password</label>
                                        <input type="text" class="form-control" placeholder="Enter New Password"
                                            name="password" required />
                                    </div>
                                </div>


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Confirm Password</label>
                                        <input type="text" class="form-control" placeholder="Confirm New Password"
                                            name="password_confirmation" required />
                                    </div>
                                </div>

                            </div>

                            <input type="hidden" name="id" value="{{$edit->id}}">

                            @if(!isset($edit->id))
                            <br>

                            <div class="row mb-4">

                                <div class="form-check">
                                    <input type="checkbox" name="check_next" id="stayOnPage" value="1">

                                    <label class="form-check-label" for="stayOnPage">
                                        Stay On this page after i clicked <strong>Save</strong>
                                    </label>
                                </div>


                            </div>

                            @endif
                            <input type="hidden" name="id" value="{{$edit->hashid}}">
                            <button type="submit"
                                class="btn btn-raised btn-primary btn-round waves-effect">{{isset($edit) ? 'Update' :
                                'Save'}}</button>
                        </form>






                    </div>
                </div>
                {{-- for password --}}

            </div>
        </div>
    </div>
</section>

@endsection

@section('page-scripts')
<!-- Jquery DataTable Plugin Js -->
<script src="{{asset('front')}}/assets/bundles/datatablescripts.bundle.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
<script src="{{asset('front')}}/assets/js/pages/tables/jquery-datatable.js"></script>


<script>
    $('.ajaxForm').submit(function(e) {
        e.preventDefault();
        var url = $(this).attr('action');
        var param = new FormData(this);
        my_ajax(url, param, 'post', function(res) {}, true);
    });

</script>
@endsection
