<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_registrations', function (Blueprint $table) {
            $table->id();
            $table->integer('course_id');
            $table->string('name', 255)->nullable();
            $table->string('date_of_birth', 255)->nullable();
            $table->string('course_name', 255)->nullable();
            $table->double('course_price')->nullable();
            $table->string('marks', 255)->nullable();
            $table->enum('status', ['pass','fail'])->default('pass');
            $table->string('payment_status', 255)->nullable();
            $table->integer('certification_number')->nullable();
            $table->integer('invoice_number')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_registrations');
    }
};
