@php

$path = public_path('/front/assets/images/certificate.jpg');

$image = file_get_contents($path);

$base64 = base64_encode($image);

@endphp

<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Certificate of Achievement</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>

        body {

            font-family: 'Times New Roman', Times, serif;

            display: flex;

            justify-content: center;

            align-items: center;

            margin: 0;

            padding: 0;

        }



        .certificate-container {

            padding: 40px;

            max-width: 800px;

            text-align: center;

            background-image: url('data:image/jpeg;base64,{{ $base64 }}');

            background-position: center;

            background-size: cover;

            position: relative;

        }



        .certificate-header img {

            height: 80px;

            margin-bottom: 20px;

        }



        .certificate-title {

            font-size: 32px;

            font-weight: bold;

            margin-bottom: 20px;

        }



        .certificate-subheader {

            font-size: 20px;

            margin-bottom: 40px;

        }



        .recipient-name {

            font-size: 28px;

            font-weight: bold;

            margin-bottom: 20px;

        }



        .certificate-body {

            font-size: 18px;

            margin-bottom: 30px;

        }



        .organization-name {

            font-size: 24px;

            font-weight: bold;

            margin-bottom: 20px;

        }



        .signature {

            margin-top: 50px;

            font-style: italic;

            font-size: 20px;

        }



        .footer {

            font-size: 16px;

            margin-top: 40px;

        }

    </style>

</head>



<body onload="window.print()">

    <div class="certificate-container">

        <div class="certificate-header">

            <img src="{{'data:image/png;base64,'.base64_encode(file_get_contents(public_path('/front/assets/images/OSHTA-Logo.png')))}}" alt="OSHTA Logo">

            <p class="certificate-title">CERTIFICATE OF ACHIEVEMENT</p>

        </div>

        <div class="certificate-subheader">

            This certificate is awarded to

        </div>

        <div class="recipient-name">

            {{ $cards->user->full_name ?? '' }}

        </div>

        <div class="certificate-body">

            on successfully completing <br><strong>OSHTA Train the Trainer</strong><br>

            a course approved and validated by the<br><strong>OSHTA</strong><br>

            in association with Approved Training Partner<br>

            <div class="organization-name">Stairs International</div>

            Canter Number: 0295<br>

             Certificate No: TTT-{{ $cards->user_id ?? '' }}<br>
{{-- @dd($latestUserTest->created_at);  --}}
            Issued on: {{ $latestUserTest->created_at->format('d M Y') ?? '' }}<br>

            Validity: {{ $latestUserTest->created_at->addYear()->format('d M Y') ?? '' }}

        </div>

        <div class="signature">

            <img src="{{'data:image/png;base64,'.base64_encode(file_get_contents(public_path('/front/assets/images/Samantha_Signature.png')))}}" alt="Signature" class="img-fluid" style="height: 40px;"><br>

            Training Director

        </div>

        <div class="footer">

            <a href="http://www.oshta.at">www.oshta.at</a>

        </div>

        <img src="{{'data:image/png;base64,'.base64_encode(file_get_contents(public_path('/front/assets/images/Qrcode.png')))}}" alt="QR Code" width="100" height="100">

    </div>

</body>



</html>

