<?php

namespace App\Http\Controllers\Administrator;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Mail\VerificationEmail;
use Illuminate\Support\Facades\Mail;
use App\Models\PartnerInvoice;
use App\Models\StudentRegistration;
use Dompdf\Dompdf;
use Dompdf\Options;
use Illuminate\Support\Facades\DB;

class AdminApprovePartnerController extends Controller
{
    public function approval_partner()
    {
        $data = [
            'title' => 'partner',
            'sidebar_menu' => 'all_partner',
            'partner_data' => User::where('user_type', 'partner')->latest()->get(),
        ];

        return view('admin.approval_partner')->with($data);
    }

    public function updateApprovalStatus(Request $request)
    { 
        $validated = $request->validate([
            'id' => 'required|integer',
            'approved' => 'required',
        ]);

        $partner = User::find($validated['id']); 
        if ($partner) {
            if($request->approved == 'withoutPayment'){
                $partner->is_verified = 1;
                $partner->save();  
            }
            
            $data = array(
                'partner_name' => $partner->institute_name,
                'approve_type' => $request->approved,
                'id' => $validated['id'],
            );

            Mail::to($partner->email)->send(new VerificationEmail($data));

            $msg = [
                'success' => 'Partner Approve Successfully',
                'reload' => true,
            ];
            return response()->json($msg);
        } else {
            return response()->json(['success' => false], 404);
        }
    }
    // public function updateApprovalStatus(Request $request)
    // {
    //     // Validate the incoming request
    //     $validated = $request->validate([
    //         'id' => 'required|integer',
    //         'approved' => 'required',
    //     ]);

    //     // Find the partner by the validated ID
    //     $partner = User::find($validated['id']);

    //     if ($partner) {
    //         // Check if payment is completed in the partner_payment_methods table for the given partner
    //         $paymentStatus = DB::table('partner_payment_methods')
    //             ->where('user_id', $partner->id)
    //             ->where('payment_status', 'COMPLETED')
    //             ->exists(); // Check if any row with COMPLETED status exists

    //         if ($paymentStatus) {
    //             // If payment is completed, approve the partner automatically
    //             $partner->is_verified = 1;
    //             $partner->save();

    //             // Send the verification email
    //             $data = [
    //                 'partner_name' => $partner->institute_name,
    //                 'approve_type' => 'withPayment', // Automatically setting approve type with payment
    //             ];

    //             Mail::to($partner->email)->send(new VerificationEmail($data));

    //             // Return success response
    //             $msg = [
    //                 'success' => 'Partner Approved due to Completed Payment',
    //                 'reload' => true,
    //             ];
    //             return response()->json($msg);
    //         } else {
    //             // If no completed payment is found, return an error message
    //             return response()->json([
    //                 'success' => false,
    //                 'message' => 'Payment not completed, partner cannot be approved.'
    //             ], 400);
    //         }
    //     } else {
    //         // If the partner is not found
    //         return response()->json(['success' => false, 'message' => 'Partner not found.'], 404);
    //     }
    // }


    public function partner_info($id)
    {
        $encodedId = hashids_decode($id);

        $invoices = PartnerInvoice::where('partner_id', $encodedId)
            ->get();

        $students = StudentRegistration::whereIn('invoice_id', $invoices->pluck('id'))->get();
        $data = [
            'title' => 'Partner Info',
            'students' => $students,
            'sidebar_menu' => 'all_partner',
        ];
        return view('admin.partner_info.info')->with($data);
    }
    public function save_modal_data(Request $request)
    {
        $student = StudentRegistration::find($request->student_id);
        if ($student) {
            $student->marks = $request->marks;

            // Update status based on marks
            if ($request->marks < 45) {
                $student->status = 'fail';
                $student->certification_number = null;
            } else {
                $student->status = 'pass';

                // Generate a unique certification number
                $student->certification_number = $this->generateNumber();
            }
            $student->save();
            $msg = [
                'success' => 'Student data updated successfully.',
                'reload' => true,
            ];
            return response()->json($msg);
        }
        return ['error' => 'Student not found.'];
    }
    private function generateNumber()
    {
        $prefix = 'cert';
        do {
            $certificationNumber = str_pad(mt_rand(1, 999999), 6, '0', STR_PAD_LEFT);
            $certificationNumber = $certificationNumber;
            $exists = StudentRegistration::where('certification_number', $certificationNumber)->exists();
        } while ($exists);

        return $certificationNumber;
    }
    public function download_certificate($id)
    {
        $student = StudentRegistration::findOrFail($id);

        // Prepare data for the certificate view
        $data = [
            'student' => $student,
            'title' => 'Certificate of Completion',
        ];
        // Render the HTML content with the student data
        // return view('client.partner_invoice.certificate', $data);
        $pdfContent = view('client.partner_invoice.certificate', $data)->render();

        // Initialize Dompdf with options
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isPhpEnabled', true);

        $dompdf = new Dompdf($options);

        $dompdf->setPaper('A4', 'portrait');

        $dompdf->loadHtml($pdfContent);

        $dompdf->render();

        $pdfPath = 'pdfs/' . 'certificate-' . $student->id . '.pdf';
        file_put_contents(storage_path('app/' . $pdfPath), $dompdf->output());

        return response()->download(storage_path('app/' . $pdfPath));
    }
}
