<?php

namespace App\Http\Controllers\Administrator;

use App\Http\Controllers\Controller;
use App\Models\CardCategories;
use App\Models\Cards;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class CardsController extends Controller
{

    public function add_cards()
    {

        $data = array(
            'title' => 'Add Cards',
            'sub_title' => 'Add cards',
            'sidebar_menu' => 'add_cards',
            'cardTitles' => CardCategories::all(),

        );

        return view('admin.cards.add_cards')->with($data);
    }
    public function edit($id)
    {
        $data = array(
            'title' => 'Cards',
            'edit' => Cards::hashidFind($id),
            'sub_title' => 'Edit Cards',
            'sidebar_menu' => 'Cards',
            'cardTitles' => CardCategories::all(),
 
        );  
        return view('admin.cards.add_cards')->with($data);
    }
    public function save(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'category' => 'required',
            'price' => 'required',
        ]);

        DB::beginTransaction();

        try {
            if ($request->id) {
                $card = Cards::findOrFail($request->id);
                $text = 'Cards Updated Successfully';
            } else {
                $card = new Cards();
                $text = 'Cards Created Successfully';
            }

            $card->title = $request->title;
            $card->category = $request->category;
            $card->price = $request->price;

            // // Agar card naya create ho raha hai to card_validate automatically set hoga
            // if (!$request->id) {
            //     $card->created_at = Carbon::now();
            //     $card->card_validate = Carbon::parse($card->created_at)->addYear();
            // }

            $card->save();
            DB::commit();

            if ($request->ajax() && $request->check_next == 1) {
                $msg = [
                    'success' => $text,
                    'redirect' => route('admin.cards.add'),
                ];
                return response()->json($msg);
            } else {
                $msg = [
                    'success' => $text,
                    'redirect' => route('admin.cards.all'),
                ];
                return response()->json($msg);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong! Please try again.',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
    public function all_cards()
    {
        $data = array(
            'title' => 'All Cards',
            'sub_title' => 'All cards',
            'sidebar_menu' => 'add_cards',
            'all_data' => Cards::with('CardCategories')->latest()->get(),
        );
        return view('admin.cards.all_cards')->with($data);
    }

    public function delete($id)
    {
        $Cards = Cards::hashidFind($id);

        if ($Cards) {
            $Cards->delete();

            return response()->json([
                'success' => 'Cards deleted successfully.',
                'reload' => true,
            ]);
        } else {
            return response()->json([
                'success' => 'Cards not found.',
                'reload' => true,
            ], 404);
        }
    }
}
