<?php

namespace App\Http\Controllers\Administrator;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\Course;
use App\Models\StudentRegistration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;



class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function index(Request $request)
    {
        $verifiedUsersCount = DB::table('users')->where('is_verified', 1)->count();
        $approvalRequestCount = DB::table('users')->where('is_verified', 0)->count();
        $courseCount = Course::all()->count();
        $StudentCount = StudentRegistration::all()->count();

        $data = array(
            'breadcrumb' => 'Dashboard',
            'title' => "Dashboard",
            'sidebar_menu' => 'dashboard',
            'verifiedUsersCount' => $verifiedUsersCount,
            'approvalRequestCount' => $approvalRequestCount,
            'courseCount' => $courseCount,
            'StudentCount' => $StudentCount,
        );

        return view('admin.dashboard')->with($data);
    }
    public function edit_profile()
    {
        $data = array(
            'breadcrumb' => 'User Profile',
            'title' => 'Profile',
            'edit' => Auth('admin')->user(),
            'sidebar_menu' => "profile",
            'sub_title' => 'Edit Profile',
        );

        return view('admin.profile')->with($data);
    }


    public function update_profile(Request $request)
    {

        //  dd($request->all());

        $rules = [
            'name' => 'string',
            // 'email' => 'email',
        ];

        // if ($request->hasFile('product_image')) {
        //     $rules['product_image'] = 'image|mimes:jpeg,png,jpg';
        // }


        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return ['errors' => $validator->errors()];
        }
        $user = Admin::find($request->id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->username = $request->username;
    

        if (!empty($request->password)) {
            $user->password = bcrypt($request->password);
        }

        $user->save();

        return response()->json([
            'success' => 'Profile Updated Successfully',
            'reload' => true,
        ]);
    }
    public function update_password(Request $request)
    {
        $rules = [
            'current_password' => 'required',
            'password' => 'required|min:8|max:12|confirmed',
        ];

        $messages = [
            'password.regex' => 'Invalid Format. Password should be 8 characters, with at least 1 number and special characters.',
        ];

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return ['errors' => $validator->errors()];
        }

        $admin = Admin::FindOrfail($request->id);
   
        if (!Hash::check($request->current_password, $admin->password)) {
            $msg = [
                'error' => 'Current Password Not Match',
              
            ];
        } else {
            $admin->password = Hash::make($request->password);
            $admin->save();
            $msg = [
                'success' => 'Admin password has been updated',
                'reload' => true,
            ];
        }
        return response()->json($msg);
    }
}
