<?php

namespace App\Models;

use App\Traits\DianujHashidsTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CardExam extends Model
{
    use HasFactory, SoftDeletes, DianujHashidsTrait;
    protected $fillable = [];

    public function questions()
    {
        return $this->hasMany(CardExamQuestion::class, 'card_exam_id', 'id');
    }

    public function CardExamQuestion()
    {
        return $this->hasMany(CardExamQuestion::class, 'card_exam_id', 'id');
    }
    public function card()
    {
        return $this->belongsTo(Cards::class, 'card_id');
    }
    public function QuestionOptions()
    {
        return $this->hasMany(QuestionOption::class, 'question_id', 'id');
    }
    public function userTests()
    {
        return $this->hasMany(UserTest::class, 'exam_id');
    }
}
