<?php

namespace App\Models;

use App\Models\PartnerInvoice;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\DianujHashidsTrait;

class StudentRegistration extends Model
{
    use HasFactory;
    use SoftDeletes;
    use DianujHashidsTrait;

    function Course(){
        return $this->belongsTo(Course::class,'course_id');
    }

    public function partnerInvoice()
    {
        return $this->belongsTo(PartnerInvoice::class, 'invoice_id');
    }
}
