<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('institute_name');
            $table->string('head_institute');
            $table->string('phone_number')->nullable();
            $table->string('image')->nullable();
            $table->string('email')->unique();
            $table->string('address')->nullable();
            $table->string('city');
            $table->string('country');
            $table->string('website')->nullable();
            $table->string('business_registration')->nullable();
            $table->string('user_name')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
        Schema::table('users', function (Blueprint $table) {
            $table->string('user_name')->unique()->after('email');
        });
    
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
