@section('title', 'Forgot Password')
@php
    $title = 'Forgot Password';
@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/iofrm-style.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/assets/css/iofrm-theme12.css">
</head>

<body>
    <div class="form-body">
        <div class="row">
            <div class="form-holder">
                <div class="form-content">
                    <div class="form-items">
                        <div class="website-logo-inside">
                            <a href="#">
                                <div class="">
                                    <img class="logo-size" src="{{asset('front')}}/assets/images/OSHTA-Logo.png" alt="">
                                </div>
                            </a>
                        </div>
                        <h3>Admin Forgot Password?</h3>
                        <p class="card-text text-center mb-4">Enter your registered email address to reset your
                            password.</p>
                        @if (session('success'))
                            <div class="alert alert-success text-center">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger text-center">
                                {{ session('error') }}
                            </div>
                        @endif
                        <form action="{{ route('admin.send_email') }}" method="post">
                            @csrf
                            <div class="mb-3">
                                <label for="inputEmailid" class="form-label">Email</label>
                                <input type="email" class="form-control form-control-lg" name="email"
                                    value="{{ old('email') }}" id="inputEmailid" placeholder="Email Address" required>
                                @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary btn-lg">Send</button>
                                <a href="{{ route('admin.login') }}" class="btn btn-light btn-lg">Back to Login</a>
                            </div>
                        </form>
                    </div>
                    <div class="form-sent">
                        <div class="website-logo-inside">
                            <a href="index.html">
                                <div class="logo">
                                    <img class="logo-size" src="images/logo-light.svg" alt="">
                                </div>
                            </a>
                        </div>
                        <div class="tick-holder">
                            <div class="tick-icon"></div>
                        </div>
                        <h3>Password link sent</h3>
                        <p>Please check your inbox iofrm@iofrmtemplate.io</p>
                        <div class="info-holder">
                            <span>Unsure if that email address was correct?</span> <a href="#">We can help</a>.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="login-images mt-5">
        <img src="{{ asset('front') }}/assets/css/images/login_mbl_image1.png" class="footer-image img-fluid"
            alt="Footer Image">
        <img src="{{ asset('front') }}/assets/css/images/login_mbl_image2.png" class="monkey-image img-fluid"
            alt="Monkey Image">
    </div>
    <script src="{{ asset('front') }}/assets/js/jquery.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/popper.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/bootstrap.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/main.js"></script>
</body>

</html>

@section('page-script')

@endsection
