@extends('layouts.admin_auth')
@section('title', 'Login')
@php
    $title = 'login';
@endphp
@section('content')
<div class="col-md-12 content-center">
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card-plain">
                <div class="header">
                    <img src="{{asset('front')}}/assets/images/OSHTA-Logo.png" width="80" height="80" alt="OSHTA">
                    <h5>Log in</h5>
                </div>
                <form class="form" action="{{ route('admin.login.submit') }}"  method="post" novalidate class="form-body">
                    @csrf
                    <div class="input-group">
                        <input type="text" name="username" class="form-control radius-30 ps-5"
                        value="{{ old('username') }}" id="inputUserName"
                        placeholder="Username Or Email" required>
                        <span class="input-group-addon"><i class="zmdi zmdi-account-circle"></i></span>
                    </div>
                    @error('username')
                    <span class="text-danger fw-bold">{{ $message }}</span>
                @enderror
                    <div class="input-group">
                        <input type="password" class="form-control radius-30 ps-5"
                        id="inputChoosePassword" placeholder="Enter Password" name="password">
                        <span class="input-group-addon"><i class="zmdi zmdi-lock"></i></span>
                    </div>                            
                
                <div class="footer">
                    <button type="submit" class="btn btn-primary btn-round btn-block">Sign In</button>
                </div>
            </form>
            <a href="{{ route('admin.change_password') }}" class="link">Forgot Password?</a>
            </div>
        </div>
    </div>
</div>
@endsection
@section('page-script')
    
@endsection
