<style>
    .result-container {
        padding-top: 10px;
    }

    .result-container p {
        font-size: 1rem;
        line-height: 1.5;
    }
</style>
@extends('layouts.front')
@section('page-css')
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection
@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success" id="flash-message">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger" id="flash-message">
                    {{ session('error') }}
                </div>
            @endif

            <div class="row clearfix">
                @foreach ($all_data as $all)
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center position-relative">
                            <div class="body position-relative" style="height:460px;">
                                <p class="m-b-20">
                                    <i class="fas fa-medal zmdi-hc-3x col-primary"></i>
                                </p>
                                <h4 class="m-b-10">{{ $all->title }}</h4>
                                <p style="display: none;">Exam: {{ $all->exam->title ?? '' }}</p>
                                <p>Category: {{ $all->CardCategories->title }}</p>
                                @if ($all->userCard)
                                    <p>Exam Questions: 50</p>
                                @else
                                    <p>Price: {{ get_price($all->price) }}</p>
                                @endif
                                @php
                                $alreadyPurchased = DB::table('user_cards')
                                    ->where('user_id', auth('web')->id())
                                    ->where('card_id', $all->id)
                                    ->exists();
                            @endphp
                                @if ($all->userCard)
                                    <p><strong>Purchase Date:</strong> {{ get_date($all->userCard->created_at) }}</p>

                                     @if($all->test_result >= 50)
                                        <p><strong>Expire Date:</strong> {{ get_date($all->userCard->created_at->addYear()) }}</p>
                                    @else
                                         <p><strong>Exam Deadline:</strong> {{ get_date($all->userCard->created_at->addMonth()) }}</p>
                                    @endif

                                @endif

                                <div>


                                    @if ($alreadyPurchased)
                                        <span class="badge badge-success">Purchased</span> <br>

                                        @php
                                            $purchasedDate = $all->userCard->created_at;
                                            $currentDate = \Carbon\Carbon::now();
                                            $daysDifference = $currentDate->diffInDays($purchasedDate);
                                        @endphp
                                       @if ($all->test_result != '')
                                       <p><strong>Result: {{ $all->test_result }}% </strong>
                                            @if ($all->test_result >= 50)
                                                <strong>(Pass)</strong>
                                            @else
                                                <strong>(Fail)</strong>
                                            @endif
                                        </p>
                                        @endif
                                        @if ($daysDifference <= 30 && ($all->test_result < 50))
                                            <a href="{{ route('user.cards.save_exams', hashids_encode($all->id)) }}"
                                                class="btn btn-success">Attempt Exam</a>
                                        @else
                                            <span></span>
                                        @endif
                                    @else
                                        <a class="btn btn-warning buy-card form-submit-btn"
                                            data-card-id="{{ $all->id }}" data-card-name="{{ $all->title }}"
                                            data-exam-name="{{ $all->exam->title ?? '' }}" data-card-price="{{ $all->price ?? '' }}"
                                            href="{{route('user.cards.buy_card',$all->id)}}">
                                            <i class="fas fa-shopping-cart"></i>&nbsp;&nbsp;Buy Now
                                        </a>
                                    @endif
                                </div>

                                <div>
                                    @if ($all->test_result === null)
                                        <span></span>
                                    @else
                                        @if ($all->test_result >= 50)
                                            @if ($all->test_result >= 80)
                                            <button type="button" class="btn btn-primary btn-sm">
                                                <a href="{{ route('user.cards.special_certificate', $all->userCard->id) }}" class="text-white" target="_blank">Special Certificate &nbsp;<i class="fas fa-download"></i></a>
                                            </button>
                                            <button type="button" class="btn btn-primary btn-sm">
                                                <a href="{{ route('user.cards.pass_certificate', $all->userCard->id) }}" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                            </button>
                                            @else
                                            <button type="button" class="btn btn-primary btn-sm">
                                                <a href="{{ route('user.cards.pass_certificate', $all->userCard->id) }}" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                            </button>
                                            @endif
                                        @else
                                            <span></span>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection

@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>

<script>
    // Wait 3 seconds before fading out the flash message
    setTimeout(function() {
        var flashMessage = document.getElementById('flash-message');
        if (flashMessage) {
            flashMessage.style.transition = 'opacity 0.5s ease'; // Smooth transition
            flashMessage.style.opacity = '0'; // Hide the message
            setTimeout(function() {
                flashMessage.remove(); // Remove the element from DOM after fading out
            }, 500); // Wait for the fade-out to finish
        }
    }, 3000); // Display for 3 seconds before hiding
</script>
@endsection
