<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="{{asset('front')}}/assets/plugins/bootstrap/css/bootstrap.min.css">
    <title>Approval Waiting</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box; 
        }
        .main_div {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            background-color: grey;
            height: 100vh;
            width: 100%;
        }
        .logo-size {
            margin-bottom: 20px; /* Space between image and the header div */
        }
        .header {
            width: 500px;
            height: 300px;
            background-color: white;
            border-radius: 10px; 
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center; 
            display: flex;
            flex-direction: column;
            justify-content: center; 
        }
        
        img{
            margin-bottom: 25px;
        }
        .paypal-button 
        {
            background-color: #ffc439; 
            color: white;            
            font-size: 16px;          
            font-weight: bold;         
            padding: 12px 24px;        
            border: none;              
            border-radius: 5px;        
            cursor: pointer;           
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.15);
            transition: background-color 0.3s ease;
            width: 230px;
        }

        .paypal-button:hover {
            background-color: #ffb300; 
        }
        .payment-info {
            margin-top: 10px;
            color: #555;
            text-align: center;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="main_div">
    @if(session('error'))
        <div class="alert alert-danger" id="flash-message">
            {{ session('error') }}
        </div>
    @endif
        
        <div class="header" style=" align-items: center; ">
            <img src="{{ asset('front') }}/assets/images/OSHTA-Logo.png" alt="logo" width="100px" >
            <form action="{{ route('paypalPayment.paypal', ['id' => $id]) }}" method="post">
                @csrf
                <h5 class="payment-info" id="price-display">The payment amount is {{get_price(300)}}</h5>

                <button type="submit" class="paypal-button">Pay Now</button>

            </form>
            
        </div>
    </div>

    <script>
        // Wait 3 seconds before fading out the flash message
        setTimeout(function() {
            var flashMessage = document.getElementById('flash-message');
            if (flashMessage) {
                flashMessage.style.transition = 'opacity 0.5s ease'; // Smooth transition
                flashMessage.style.opacity = '0'; // Hide the message
                setTimeout(function() {
                    flashMessage.remove(); // Remove the element from DOM after fading out
                }, 500); // Wait for the fade-out to finish
            }
        }, 3000); // Display for 3 seconds before hiding
    </script>    
</body>
</html>