<?php



use Illuminate\Support\Facades\Route;

use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\Auth\AdminLoginController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Frontend\PartnerApprovePaymentController;
use App\Http\Controllers\Frontend\PartnerInvoiceController;
use App\Models\Role;

//Clear Cache facade value:
Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    return '<h1>Cache facade value cleared</h1>';
});

//Reoptimized class loader:
Route::get('/optimize', function() {
    $exitCode = Artisan::call('optimize');
    return '<h1>Reoptimized class loader</h1>';
});

//Route cache:
Route::get('/route-cache', function() {
    $exitCode = Artisan::call('route:cache');
    return '<h1>Routes cached</h1>';
});

//Clear Route cache:
Route::get('/route-clear', function() {
    $exitCode = Artisan::call('route:clear');
    return '<h1>Route cache cleared</h1>';
});

//Clear View cache:
Route::get('/view-clear', function() {
    $exitCode = Artisan::call('view:clear');
    return '<h1>View cache cleared</h1>';
});

//Clear Config cache:
Route::get('/config-cache', function() {
    $exitCode = Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});



Auth::routes(['verify' => true]);


// email link page route

Route::prefix('paypalPayment')->as('paypalPayment.')->controller('App\Http\Controllers\PaypalPaymentController')->group(function () {

    Route::get('/index_paypal/{id}', 'index_paypal')->name('index_paypal');
    Route::post('/paypal', 'paypal')->name('paypal');
    Route::get('/success/{id}', 'success')->name('success');
    Route::get('/cancel/{id}', 'cancel')->name('cancel');
});



//admin auth routes

Route::prefix('web_admin')->middleware('XSS')->controller(AdminLoginController::class)->as('admin.')->group(function () {

    Route::get('/login', 'showLoginForm')->name('login');

    Route::post('/logout', 'logout')->name('logout');

    Route::post('/login', 'login')->name('login.submit');

    Route::get('/change_password', 'change_password')->name('change_password');

    Route::get('/forget_password', 'forget_password')->name('forget_password');

    Route::post('/send_email', 'send_email')->name('send_email');

    Route::get('/add_new_pasword/{id}', 'password_screen')->name('add_new_pasword');

    Route::post('/save_new_password', 'save_new_password')->name('save_new_password');

});

Route::get('/', function () {
    if (auth('admin')->check()) {
        return redirect()->route('admin.home');
    } else {
        // return redirect(route('login'));
        return redirect(url('/user/login'));
        // abort(404);
    }
});

Route::middleware(['auth:admin'])->prefix('web_admin')->as('admin.')->namespace('App\Http\Controllers\Administrator')->group(function () {

    Route::get('/', 'DashboardController@index')->name('home');

    Route::post('/save_sub_account', 'DashboardController@save_sub_account')->name('save_sub_account');

    Route::get('/notifications', 'DashboardController@notifications')->name('notifications');

    Route::get('/update_notifications', 'DashboardController@update_notifications')->name('update_notifications');

    Route::get('/update-sub-account-status/{id}/{status}', 'DashboardController@update_sub_account_status')->name('update_sub_account_status');

    Route::get('/sub_account/{id}', 'DashboardController@subAccountShow')->name('sub_account');

    Route::get('/admin/view_progress/{id}/{subAccountId}', 'DashboardController@view_progress')->name('view_progress');

    Route::get('/admin/view_progress/datatable/{id}/{subAccountId}', 'DashboardController@view_progress_datatable')->name('view_progress_datatable');

    Route::get('/update-profile', 'DashboardController@update_profile')->name('update-profile');
   
    
    // // //Approve Partner Registration

    Route::middleware(['XSS'])->prefix('approval')->as('approval.')->controller('AdminApprovePartnerController')->group(function () {

        Route::get('/partner', 'approval_partner')->name('partner');
        
        Route::get('/update-approval-status', 'updateApprovalStatus')->name('update-approval-status');

        Route::get('/partner_info/{id}', 'partner_info')->name('partner_info');

        Route::post('/save', 'save_modal_data')->name('save');

        Route::get('/generate_number', 'generateNumber')->name('generate_number');

        Route::get('/certificate/{id}', 'download_certificate')->name('certificate');

    });

    // // course

    Route::middleware(['XSS'])->prefix('course')->as('course.')->controller('CourseController')->group(function () {

        Route::get('/', 'index')->name('course');

        Route::get('/add', 'add_course')->name('add');

        Route::get('/all_course', 'all_course')->name('all_course');

        Route::post('/save', 'save')->name('save');

        Route::get('/edit/{id}', 'edit')->name('edit');
        Route::get('/delete{id}', 'delete')->name('delete');

    });

      // // Cards

        Route::middleware(['XSS'])->prefix('cards')->as('cards.')->controller('CardsController')->group(function () {

        Route::get('/add', 'add_cards')->name('add');

        Route::get('/all', 'all_cards')->name('all');

        Route::post('/save', 'save')->name('save');

        Route::get('/edit/{id}', 'edit')->name('edit');

        Route::get('/delete{id}', 'delete')->name('delete');

    });

    // // Exam

    Route::middleware(['XSS'])->prefix('exam')->as('exam.')->controller('ExamController')->group(function () {

        Route::get('/add', 'add_exam')->name('add');

        // Route::get('/all', 'all_exam')->name('all');

        Route::get('/card', 'exam_card')->name('card');

        Route::post('/save', 'save')->name('save');

        Route::get('/edit/{id}', 'edit')->name('edit');

        Route::get('/delete{id}', 'delete')->name('delete');

    });

    Route::prefix('profile')->as('profile.')->group(function () {

        Route::get('/', 'DashboardController@edit_profile')->name('edit');

        Route::post('/update', 'DashboardController@update_profile')->name('update');

        Route::post('/set_token', 'DashboardController@save_device_token')->name('save_device_token');
        Route::post('/update_password', 'DashboardController@update_password')->name('update_password');
    });
});

// web user auth routes start

// routes 
Route::get('/user/login', [LoginController::class, 'showLoginForm'])->name('user/login');
Route::get('/user/register', [RegisterController::class, 'UserregisterForm'])->name('Userregister');
Route::get('/partner/login', [RegisterController::class, 'showloginForm'])->name('partner_login');
Route::get('/partner/register', [RegisterController::class, 'showRegistrationForm'])->name('partner_register');
  Route::post('/partnerlogout', [LoginController::class, 'partnerlogout'])->name('partnerlogout');
Route::get('/registeration_approval', [RegisterController::class, 'registeration_approval'])->name('register.approval');
// routes 

Route::prefix('auth')->middleware('XSS')->as('auth.')->namespace('App\Http\Controllers\Auth')->group(function () {

    Route::post('/login/submit', 'LoginController@login')->name('login.submit');
    Route::post('/logout', 'LoginController@logout')->name('logout');
    Route::get('/forget_password', 'ForgetPasswordController@forget_password')->name('forget_password');
    Route::post('/send_email', 'ForgetPasswordController@send_email')->name('send_email');
    Route::get('/add_new_pasword/{id}', 'ForgetPasswordController@password_screen')->name('add_new_pasword');
    Route::post('/save_new_password', 'ForgetPasswordController@save_new_password')->name('save_new_password');
    Route::post('/register/submit', 'RegisterController@register')->name('register.submit');
    Route::get('/success_message', 'RegisUserregisterFormterController@success_message')->name('success_message');
    Route::get('/verify/{id}', 'RegisterController@password_screen')->name('verify');
    Route::post('/password/submit', 'RegisterController@password_save')->name('password.submit');
    Route::get('/regenerate-sheet', 'RegisterController@regenerateSheet');
    Route::get('/regenerate-sheet', 'RegisterController@regenerateSheet');
    Route::post('/User_register_submit', 'RegisterController@Userregister')->name('User_register_submit');

});



Route::prefix('user')->as('user.')->middleware(['auth:web'])->namespace('App\Http\Controllers\Frontend')->group(function () {

    Route::get('/', 'DashboardController@index')->name('dashboard');

    Route::post('/get_latest_leads_dashboard', 'DashboardController@get_leads')->name('get_latest_leads_dashboard');



    Route::prefix('profile')->as('profile.')->group(function () {

        Route::get('/', 'DashboardController@edit_profile')->name('edit');

        Route::post('/update_profile', 'DashboardController@update_profile')->name('update_profile');

        Route::post('/update_password', 'DashboardController@update_password')->name('update_password');

        Route::post('/set_token', 'DashboardController@save_device_token')->name('save_device_token');

    });

    // Student

    Route::middleware(['XSS'])->prefix('student')->as('student.')->controller('StudentController')->group(function () {

        Route::get('/add_student', 'add_student')->name('add_student');

        Route::get('/add_course_fee', 'add_course_fee')->name('add_course_fee');

        Route::post('/store', 'store')->name('store');

        // Route::get('/generate_number', 'generateNumber')->name('generate_number');



    });

    // Invoice

    Route::middleware(['XSS'])->prefix('invoice')->as('invoice.')->controller('PartnerInvoiceController')->group(function () {

        Route::get('/all', 'index')->name('all');
        Route::get('/view/{id}', 'view_invoice')->name('view');
        Route::post('/save', 'save_modal_data')->name('save');
        Route::get('/certificate/{id}', 'download_certificate')->name('certificate');
        Route::get('/paid/{id}', 'paid_invoice')->name('paid');
        Route::post('/paypal', 'paypal')->name('paypal');
        Route::get('/success', 'success')->name('success');
        Route::get('/cancel', 'cancel')->name('cancel');
        Route::get('/generate_number', 'generateNumber')->name('generate_number');

    });

    // student Result

    Route::middleware(['XSS'])->prefix('result')->as('result.')->controller('StudentResultController')->group(function () {

        Route::get('/view', 'view_result')->name('view');

    });

    //payment method

    Route::middleware(['XSS'])->prefix('payment')->as('payment.')->controller('PaymentMethodController')->group(function () {

        Route::post('/create_payment', 'create_payment')->name('create_payment');
        Route::get('/order_success', 'order_success')->name('order_success');
        Route::post('/order_success_update', 'order_success_update')->name('order_success_update');

    });

    //individual User

     // // Cards/ Exam

     Route::middleware(['XSS'])->prefix('cards')->as('cards.')->controller('UserCardsController')->group(function () {

        Route::get('/all', 'all_cards')->name('all');

        Route::get('/buy_card/{id}', 'buyCard')->name('buy_card');
        Route::get('/pay_cancel', 'cancel')->name('pay_cancel');
        Route::get('/pay_success', 'success')->name('pay_success');

        Route::get('/mycard', 'my_card')->name('mycard');

        Route::get('/save_exams/{id}', 'save_exam')->name('save_exams');

        Route::get('/start_exam/{id}', 'start_exam')->name('exam_start');

        Route::post('/attempt', 'attempt_exam')->name('attempt');

        Route::post('/updateStatus', 'updateExamStatus')->name('updateStatus');

        Route::get('/pass_certificate/{id}', 'pass_certificate')->name('pass_certificate');

        Route::get('/special_certificate/{id}', 'special_certificate')->name('special_certificate');



    });

    Route::prefix('profile')->as('userprofile.')->group(function () {

        Route::get('/edit', 'DashboardController@edit_user_profile')->name('edit');

        Route::post('/update', 'DashboardController@update_user_profile')->name('update');

        // Route::post('/set_token', 'DashboardController@save_device_token')->name('save_device_token');

    });

});



// open route for check certification blade

Route::get('/verify_certification', [PartnerInvoiceController::class, 'verify_certification'])->name('verify_certification');

Route::post('/handle_verification', [PartnerInvoiceController::class, 'handle_verification'])->name('handle_verification');

Route::get('/certificate/{id}', [PartnerInvoiceController::class, 'show_certificate'])->name('certificate');

