

<?php $__env->startSection('page-css'); ?>
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2><?php echo e($title); ?></h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="body">
                            <div class="table-responsive">
                                <table id="course-table" class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Card Name</th>
                                            <th>Exam Name</th>
                                            <th>Price</th>
                                            <th>Purchased Date</th>
                                            <th>Expire Date</th>
                                            <th>Result</th>
                                            <th>Download Certificate</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $all_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $all): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($all->card_name); ?></td>
                                                <td><?php echo e($all->exam_name); ?></td>
                                                <td><?php echo e(get_price($all->card_price)); ?></td>
                                                <td><?php echo e(get_date($all->created_at)); ?></td>
                                                <td><?php echo e(get_date($all->created_at->addYear())); ?></td>
                                                <td>
                                            <?php if($all->test_result != ''): ?>
                                            <p><strong>Result: <?php echo e($all->test_result); ?>% </strong>
                                                <?php if($all->test_result >= 50): ?>
                                                <strong>(Pass)</strong>
                                                <?php else: ?>
                                                <strong>(Fail)</strong>
                                                <?php endif; ?>
                                            </p>
                                            <?php endif; ?>
                                        </td>

                                                <td>
                                                    <?php if($all->test_result !== null): ?>
                                                        <?php if($all->test_result >= 50): ?>
                                                            <?php if($all->test_result >= 80): ?>
                                                            <button type="button" class="btn btn-primary btn-sm">
                                                                <a href="<?php echo e(route('user.cards.special_certificate', $all->id)); ?>" class="text-white" target="_blank">Special Certificate &nbsp;<i class="fas fa-download"></i></a>
                                                            </button><br>
                                                            <button type="button" class="btn btn-primary btn-sm">
                                                                <a href="<?php echo e(route('user.cards.pass_certificate', $all->id)); ?>" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                                            </button>
                                                            <?php else: ?>
                                                            <button type="button" class="btn btn-primary btn-sm">
                                                                <a href="<?php echo e(route('user.cards.pass_certificate', $all->id)); ?>" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                                            </button>
                                                            <?php endif; ?>
                                                        
                                                        <?php else: ?>
                                                            <span>-</span>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span>-</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php
                                                        $purchasedDate = $all->created_at;
                                                        $currentDate = \Carbon\Carbon::now();
                                                        $daysDifference = $currentDate->diffInDays($purchasedDate);
                                                        $test = $all->userTests->first(); 
                                                    ?>
                                                
                                                    <?php if($daysDifference <= 30 && ($all->test_result < 50)): ?>
                                                            <a href="<?php echo e(route('user.cards.save_exams', hashids_encode($all->card_id))); ?>">Attempt Exam</a>
                                                    <?php else: ?>
                                                        <h5>-</h5>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>




<?php $__env->startSection('page-scripts'); ?>
    <!-- Jquery DataTable Plugin Js -->
    <script src="<?php echo e(asset('front')); ?>/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/js/pages/tables/jquery-datatable.js"></script>


    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\oshta_new\resources\views/client/user_cards/my_cards.blade.php ENDPATH**/ ?>