<!doctype html>
<html class="no-js " lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
<meta name="description" content="Responsive Bootstrap 4 and web Application ui kit.">
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<title><?php echo e(@$title); ?> | <?php echo e(config('app.name')); ?></title>
<link rel="icon" href="favicon.ico" type="image/x-icon"> <!-- Favicon-->
<link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/bootstrap/css/bootstrap.min.css">

<link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/css/main.css">
<link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/css/color_skins.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
<!-- Sweet Alert -->
<link href="<?php echo e(asset('front')); ?>/assets/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
<style>
.icon-color {
    color: white; /* Replace with your desired color */
}
</style>
<?php echo $__env->yieldContent('page-css'); ?>
</head>
<body class="theme-black">
<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="<?php echo e(asset('front')); ?>/assets/images/OSHTA-Logo.png" width="48" height="48" alt="OSHTA"></div>
        <p>Please wait...</p>
    </div>
</div>

<?php echo $__env->make('components.front_navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('components.front_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->yieldContent('content'); ?>



<form id="logout-form" action="<?php echo e(route('auth.logout')); ?>" method="POST" class="d-none">
    <?php echo csrf_field(); ?>
</form>



<!-- Jquery Core Js -->
<script src="<?php echo e(asset('front')); ?>/assets/bundles/libscripts.bundle.js"></script> <!-- Lib Scripts Plugin Js ( jquery.v3.2.1, Bootstrap4 js) -->
<script src="<?php echo e(asset('front')); ?>/assets/bundles/vendorscripts.bundle.js"></script> <!-- slimscroll, waves Scripts Plugin Js -->

<script src="<?php echo e(asset('front')); ?>/assets/bundles/mainscripts.bundle.js"></script>
<script src="<?php echo e(asset('front')); ?>/assets/js/pages/index.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="<?php echo e(asset('front')); ?>/assets/js/danidev.js"></script>

<?php echo $__env->yieldContent('page-scripts'); ?>

</body>
</html>
<?php /**PATH D:\laragon\www\oshta\resources\views/layouts/front.blade.php ENDPATH**/ ?>